/*==============================================================*/
/* DBMS name:      MySQL 5.0                                    */
/* Created on:     23-01-2018 10:50:34                          */
/*==============================================================*/


drop table if exists COMUNA;

drop table if exists DIVISION;

drop table if exists EMPLEADOS;

drop table if exists EMPLEADO_GRADO;

drop table if exists EMPLEADO_TITULO;

drop table if exists GRADO;

drop table if exists PERMISOS;

drop table if exists PERMISO_ESTADO;

drop table if exists REGION;

drop table if exists TIPO_PERMISO;

drop table if exists TIPO_USUARIO;

drop table if exists TITULO;

drop table if exists USUARIOLOG;

/*==============================================================*/
/* Table: COMUNA                                                */
/*==============================================================*/
create table COMUNA
(
   ID_COMUNA            int not null,
   ID_REGION            smallint,
   NM_COMUNA            varchar(40),
   primary key (ID_COMUNA)
);

/*==============================================================*/
/* Table: DIVISION                                              */
/*==============================================================*/
create table DIVISION
(
   ID_DIVISION          int not null,
   GL_DIVISION          varchar(40),
   primary key (ID_DIVISION)
);

/*==============================================================*/
/* Table: EMPLEADOS                                             */
/*==============================================================*/
create table EMPLEADOS
(
   RUT                  int not null,
   ID_DIVISION          int,
   ID_TIPOUSUARIO       smallint,
   ID_COMUNA            int,
   NOMBRE               varchar(40),
   APELLIDO             varchar(40),
   DIRECCION            varchar(120),
   TELEFONO             varchar(20),
   EMAIL                varchar(40),
   FC_INGRESO           datetime,
   LOGIN                varchar(40),
   PASSWORD             varchar(80),
   primary key (RUT)
);

/*==============================================================*/
/* Table: EMPLEADO_GRADO                                        */
/*==============================================================*/
create table EMPLEADO_GRADO
(
   ID_GRADO             int not null,
   RUT                  int not null,
   primary key (ID_GRADO, RUT)
);

/*==============================================================*/
/* Table: EMPLEADO_TITULO                                       */
/*==============================================================*/
create table EMPLEADO_TITULO
(
   ID_TITULO            int not null,
   RUT                  int not null,
   primary key (ID_TITULO, RUT)
);

/*==============================================================*/
/* Table: GRADO                                                 */
/*==============================================================*/
create table GRADO
(
   ID_GRADO             int not null,
   GL_GRADO             varchar(20),
   primary key (ID_GRADO)
);

/*==============================================================*/
/* Table: PERMISOS                                              */
/*==============================================================*/
create table PERMISOS
(
   ID_PERMISO           int not null,
   ID_TIPO_PERMISO      int,
   RUT                  int,
   ID_PERMISO_ESTADO    smallint,
   FC_INICIO            datetime,
   FC_TERMINO           datetime,
   primary key (ID_PERMISO)
);

/*==============================================================*/
/* Table: PERMISO_ESTADO                                        */
/*==============================================================*/
create table PERMISO_ESTADO
(
   ID_PERMISO_ESTADO    smallint not null,
   GL_ESTADO            varchar(40),
   primary key (ID_PERMISO_ESTADO)
);

/*==============================================================*/
/* Table: REGION                                                */
/*==============================================================*/
create table REGION
(
   ID_REGION            smallint not null,
   NM_REGION            varchar(80),
   primary key (ID_REGION)
);

/*==============================================================*/
/* Table: TIPO_PERMISO                                          */
/*==============================================================*/
create table TIPO_PERMISO
(
   ID_TIPO_PERMISO      int not null,
   GL_DESCRIPCION       varchar(40),
   primary key (ID_TIPO_PERMISO)
);

/*==============================================================*/
/* Table: TIPO_USUARIO                                          */
/*==============================================================*/
create table TIPO_USUARIO
(
   ID_TIPOUSUARIO       smallint not null,
   GL_TIPO              varchar(40),
   primary key (ID_TIPOUSUARIO)
);

/*==============================================================*/
/* Table: TITULO                                                */
/*==============================================================*/
create table TITULO
(
   ID_TITULO            int not null,
   RUT                  int,
   GL_TITULO            varchar(80),
   primary key (ID_TITULO)
);

/*==============================================================*/
/* Table: USUARIOLOG                                            */
/*==============================================================*/
create table USUARIOLOG
(
   ID_LOG               int not null,
   RUT                  int,
   GL_LOG               varchar(160),
   FC_LOG               datetime,
   primary key (ID_LOG)
);

alter table COMUNA add constraint FK_RELATIONSHIP_13 foreign key (ID_REGION)
      references REGION (ID_REGION) on delete restrict on update restrict;

alter table EMPLEADOS add constraint FK_RELATIONSHIP_11 foreign key (ID_TIPOUSUARIO)
      references TIPO_USUARIO (ID_TIPOUSUARIO) on delete restrict on update restrict;

alter table EMPLEADOS add constraint FK_RELATIONSHIP_12 foreign key (ID_COMUNA)
      references COMUNA (ID_COMUNA) on delete restrict on update restrict;

alter table EMPLEADOS add constraint FK_RELATIONSHIP_8 foreign key (ID_DIVISION)
      references DIVISION (ID_DIVISION) on delete restrict on update restrict;

alter table EMPLEADO_GRADO add constraint FK_RELATIONSHIP_6 foreign key (RUT)
      references EMPLEADOS (RUT) on delete restrict on update restrict;

alter table EMPLEADO_GRADO add constraint FK_RELATIONSHIP_7 foreign key (ID_GRADO)
      references GRADO (ID_GRADO) on delete restrict on update restrict;

alter table EMPLEADO_TITULO add constraint FK_RELATIONSHIP_2 foreign key (RUT)
      references EMPLEADOS (RUT) on delete restrict on update restrict;

alter table EMPLEADO_TITULO add constraint FK_RELATIONSHIP_3 foreign key (ID_TITULO)
      references TITULO (ID_TITULO) on delete restrict on update restrict;

alter table PERMISOS add constraint FK_RELATIONSHIP_15 foreign key (ID_PERMISO_ESTADO)
      references PERMISO_ESTADO (ID_PERMISO_ESTADO) on delete restrict on update restrict;

alter table PERMISOS add constraint FK_RELATIONSHIP_4 foreign key (ID_TIPO_PERMISO)
      references TIPO_PERMISO (ID_TIPO_PERMISO) on delete restrict on update restrict;

alter table PERMISOS add constraint FK_RELATIONSHIP_5 foreign key (RUT)
      references EMPLEADOS (RUT) on delete restrict on update restrict;

alter table TITULO add constraint FK_RELATIONSHIP_1 foreign key (RUT)
      references EMPLEADOS (RUT) on delete restrict on update restrict;

alter table USUARIOLOG add constraint FK_RELATIONSHIP_14 foreign key (RUT)
      references EMPLEADOS (RUT) on delete restrict on update restrict;

